;(function () {
	
	'use strict';

	var isMobile = {
		Android: function() {
			return navigator.userAgent.match(/Android/i);
		},
			BlackBerry: function() {
			return navigator.userAgent.match(/BlackBerry/i);
		},
			iOS: function() {
			return navigator.userAgent.match(/iPhone|iPad|iPod/i);
		},
			Opera: function() {
			return navigator.userAgent.match(/Opera Mini/i);
		},
			Windows: function() {
			return navigator.userAgent.match(/IEMobile/i);
		},
			any: function() {
			return (isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Opera() || isMobile.Windows());
		}
	};




	var fullHeight = function() {

		// if ( !isMobile.any() ) {
			$('.js-fullheight').css('height', $(window).height() - $('#whs-header').height());
			$(window).resize(function(){
				$('.js-fullheight').css('height', $(window).height() - $('#whs-header').height());
			});
		// }

	};






	// iPad and iPod detection	
	var isiPad = function(){
		return (navigator.platform.indexOf("iPad") != -1);
	};

	var isiPhone = function(){
	    return (
			(navigator.platform.indexOf("iPhone") != -1) || 
			(navigator.platform.indexOf("iPod") != -1)
	    );
	};

	// Main Menu Superfish
	var mainMenu = function() {

		$('#whs-primary-menu').superfish({
			delay: 0,
			animation: {
				opacity: 'show'
			},
			speed: 'fast',
			cssArrows: true,
			disableHI: true
		});

	};

	var sliderMain = function() {
		
	  	$('#whs-hero .flexslider').flexslider({
			animation: "fade",
			slideshowSpeed: 5000,
			directionNav: true,			
			start: function(){
				setTimeout(function(){
					$('.slider-text').removeClass('animated fadeInUp');
					$('.flex-active-slide').find('.slider-text').addClass('animated fadeInUp');
				}, 500);
			},
			before: function(){
				setTimeout(function(){
					$('.slider-text').removeClass('animated fadeInUp');
					$('.flex-active-slide').find('.slider-text').addClass('animated fadeInUp');
				}, 500);
			}

	  	});

	  	$('#whs-hero .flexslider .slides > li').css('height', $(window).height());	
	  	$(window).resize(function(){
	  		$('#whs-hero .flexslider .slides > li').css('height', $(window).height());	
	  	});
		
		
	  	$('#whs-banner .flexslider').flexslider({
			animation: "slide",
			minItems: 1, 
			itemMargin: 0,
			itemWidth: 1162,            
			slideshowSpeed: 5000,
			controlNav: true, 
			directionNav: true
		});		

	  	$('#whs-services-section .flexslider3').flexslider({
			animation: "slide",
			slideshowSpeed: 5000,
			itemWidth: 320,            
			itemMargin: 10,
			minItems: 1, 
			maxItems: 3,
			directionNav: true			
		});	
		
		$('#whs-blog-section .flexslider4').flexslider({
			animation: "slide",
			itemWidth: 320,            
			itemMargin: 10,
			minItems: 1,
			maxItems: 3,
			directionNav: true
			
		});		

	};


	// Offcanvas and cloning of the main menu
	var offcanvas = function() {

		var $clone = $('#whs-menu-wrap').clone();
		$clone.attr({
			'id' : 'offcanvas-menu'
		});
		$clone.find('> ul').attr({
			'class' : '',
			'id' : ''
		});

		$('#whs-page').prepend($clone);

		// click the burger
		$('.js-whs-nav-toggle').on('click', function(){

			if ( $('body').hasClass('whs-offcanvas') ) {
				$('body').removeClass('whs-offcanvas');
			} else {
				$('body').addClass('whs-offcanvas');
			}
			// $('body').toggleClass('whs-offcanvas');

		});

		$('#offcanvas-menu').css('height', $(window).height());

		$(window).resize(function(){
			var w = $(window);


			$('#offcanvas-menu').css('height', w.height());

			if ( w.width() > 769 ) {
				if ( $('body').hasClass('whs-offcanvas') ) {
					$('body').removeClass('whs-offcanvas');
				}
			}

		});	

	}

	

	// Click outside of the Mobile Menu
	var mobileMenuOutsideClick = function() {
		$(document).click(function (e) {
	    var container = $("#offcanvas-menu, .js-whs-nav-toggle");
	    if (!container.is(e.target) && container.has(e.target).length === 0) {
	      if ( $('body').hasClass('whs-offcanvas') ) {
				$('body').removeClass('whs-offcanvas');
			}
	    }
		});
	};

	// Parallax
	var parallax = function() {
		$(window).stellar();
	};


	// Animations

	var contentWayPoint = function() {
		var i = 0;
		$('.animate-box').waypoint( function( direction ) {

			if( direction === 'down' && !$(this.element).hasClass('animated') ) {
				
				i++;

				$(this.element).addClass('item-animate');
				setTimeout(function(){

					$('body .animate-box.item-animate').each(function(k){
						var el = $(this);
						setTimeout( function () {
							el.addClass('fadeInUp animated');
							el.removeClass('item-animate');
						},  k * 200, 'easeInOutExpo' );
					});
					
				}, 100);
				
			}

		} , { offset: '85%' } );
	};

	var gridAutoHeight = function() {
		if (!isiPhone() || !isiPad()) {
			$('.row-half').css('height', $('.col-half').outerHeight()/2);
		}
		$(window).resize(function(){
			if (!isiPhone() && !isiPad()) {
				$('.row-half').css('height', $('.col-half').outerHeight()/2);
			}
		});
	}

	var counter = function() {
		$('.js-counter').countTo({
			formatter: function (value, options) {
	      	return value.toFixed(options.decimals);
	    	}
		});
	};

	var counterWayPoint = function() {
		if ($('#whs-counter-section').length > 0 ) {
			$('#whs-counter-section').waypoint( function( direction ) {
										
				if( direction === 'down' && !$(this.element).hasClass('animated') ) {
					setTimeout( counter , 400);					
					$(this.element).addClass('animated');
						
				}
			} , { offset: '90%' } );
		}
	};




	// Document on load.
	$(function(){
		mainMenu();
		offcanvas();
		mobileMenuOutsideClick();
		contentWayPoint();
		sliderMain();
		fullHeight();
		gridAutoHeight();
		parallax();
		counterWayPoint();
	});


}());